import {
  Text,
  SafeAreaView,
  TouchableOpacity,
  Pressable,
  Alert,
  Image,
  StatusBar,
  Platform,
  TextInput,
  Keyboard,
} from "react-native";
import React, {
  forwardRef,
  useCallback,
  useEffect,
  useImperativeHandle,
  useLayoutEffect,
  useRef,
  useState,
} from "react";
import { addDoc, collection, getDocs, query } from "firebase/firestore";
import { auth, db } from "../../../config/firebase";
import BackButton from "../../components/Buttons/BackButton";
import Loader from "../../components/Loaders/Loader";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  INPUT_CLASS_BORDER_BOTTOM,
} from "../../styles/constants";
import { FlashList } from "@shopify/flash-list";
import { View } from "react-native";
import PageLoader from "../../components/Loaders/PageLoader";
import { COLORS } from "../../styles/colors";
import { removeSpaces } from "../../utils/allFunctions";
import { COUNTRIES } from "../../utils/countries";
import { useTranslation } from "react-i18next";
import Animated, {
  FadeInRight,
  FadeOut,
  FadeOutRight,
} from "react-native-reanimated";
import { Badge, SearchBar } from "react-native-elements";

const SearchStep1 = forwardRef((props, ref) => {
  const { updateStepData, goToNextPage } = props;
  const { t, i18n } = useTranslation();
  const [selectedCountry, setSelectedCountry] = useState(null);
  const [searchTerm, setSearchTerm] = useState("");
  const [isLoading, setIsLoading] = useState(true);

  const localRef = useRef();

  useEffect(() => {
    setTimeout(() => {
      setIsLoading(false);
    }, 2000);
  }, []);

  useImperativeHandle(ref, () => ({
    async validate(item) {
      if (!item) {
        Alert.alert("Veuillez choisir un pays");
        return;
      }
      console.log(item);
      updateStepData("step1", { selectedCountry: item });
      goToNextPage();
    },
  }));

  localRef.current = ref?.current;

  const handleValidate = (item) => {
    if (localRef.current) {
      localRef.current.validate(item);
    }
  };

  const filterCountries = (text) => {
    if (text === "") {
      return COUNTRIES;
    }
    const filteredCountries = COUNTRIES.filter((country) =>
      country.name.toLowerCase().startsWith(removeSpaces(text.toLowerCase()))
    );
    return filteredCountries;
  };

  // Rendu de la liste filtrée
  const renderFilteredCountries = () => {
    const filteredCountries = filterCountries(searchTerm);

    return (
      <>
        <View className="pt-4 px-4 mb-4 flex-row items-center justify-between w-full">
          <TextInput
            style={{ fontFamily: "Inter_400Regular" }}
            className={`${INPUT_CLASS_BORDER_BOTTOM} rounded-xl border pb-3 flex-1`}
            // className={`px-3 py-2 border rounded-md border-gray-300 flex-1`}
            placeholder={`${t("text.chooseCountry")} (${COUNTRIES.length})`}
            placeholderTextColor="gray"
            onChangeText={(text) => setSearchTerm(text)}
            value={searchTerm}
          />
          {searchTerm && (
            <Animated.View
              className="w-3/12 rounded-md bg-red-500 p-2 ml-2 h-full"
              entering={FadeInRight}
              exiting={FadeOut}
            >
              <TouchableOpacity onPress={() => setSearchTerm("")}>
                <Text
                  style={{ fontFamily: "Inter_400Regular" }}
                  className="text-md text-white text-center mt-2"
                >
                  Effacer
                </Text>
              </TouchableOpacity>
            </Animated.View>
          )}
        </View>
        <FlashList
          keyboardShouldPersistTaps="handled"
          contentContainerStyle={{
            // flex: 1,
            paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
          }}
          data={filteredCountries}
          renderItem={({ item }) => (
            <TouchableOpacity
              className="flex-row items-center p-4 border-b border-gray-200"
              onPress={() => {
                Keyboard?.dismiss();
                handleValidate(item?.code);
              }}
            >
              <Image
                source={{ uri: item?.flagUrl }}
                className="mr-4 w-10 h-7 z-20"
              />
              <Text
                style={{ fontFamily: "Inter_400Regular" }}
                className="text-base"
              >
                {item?.name}
              </Text>
            </TouchableOpacity>
          )}
          keyExtractor={(item) => item.code.toString()}
          estimatedItemSize={180}
          ListEmptyComponent={() => (
            <View style={{ padding: 10 }}>
              <Text
                style={{ fontFamily: "Inter_400Regular" }}
                className="text-base"
              >
                Aucun pays trouvé.
              </Text>
            </View>
          )}
        />
      </>
    );
  };

  if (isLoading) {
    return <PageLoader />;
  }

  return (
    <SafeAreaView className="flex-1 bg-white">
      {renderFilteredCountries()}
    </SafeAreaView>
  );
});
export default SearchStep1;
